using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using HCPCS = gov.va.med.vbecs.Common.VbecsTables.HcpcsAssignment;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgHcpcsHistory
	/// </summary>
	public class DlgHcpcsHistory : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Data.DataTable _dtHcpcsHistory;

		#region Form Controls

		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.GroupBox grpHistory;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.ListView lvHistory;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors

		/// <summary>
		/// Does all the nice form stuff to populate the form
		/// </summary>
		/// <param name="bloodProductGuid"></param>
		public DlgHcpcsHistory(System.Guid bloodProductGuid)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			this.RequiredFieldsLabel = false;
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC008.DlgHcpcsHistory());

			this._dtHcpcsHistory = BOL.BloodProduct.GetHcpcsAssignmentHistory(bloodProductGuid);
			this.PopulateHCPCSAssignments();

		}


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgHcpcsHistory));
			this.btnOK = new System.Windows.Forms.Button();
			this.grpHistory = new System.Windows.Forms.GroupBox();
			this.lvHistory = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpHistory.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(412, 30);
			this.vbecsLogo1.TabIndex = 2;
			this.vbecsLogo1.Title = "HCPCS History";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 229);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 4;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Location = new System.Drawing.Point(332, 220);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 0;
			this.btnOK.Text = "&OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// grpHistory
			// 
			this.grpHistory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpHistory.Controls.Add(this.lvHistory);
			this.grpHistory.Location = new System.Drawing.Point(60, 32);
			this.grpHistory.Name = "grpHistory";
			this.grpHistory.Size = new System.Drawing.Size(348, 184);
			this.grpHistory.TabIndex = 1;
			this.grpHistory.TabStop = false;
			// 
			// lvHistory
			// 
			this.lvHistory.AccessibleDescription = "HICK PICKS History";
			this.lvHistory.AccessibleName = "HICK PICKS History";
			this.lvHistory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvHistory.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						this.columnHeader1,
																						this.columnHeader2,
																						this.columnHeader3});
			this.lvHistory.FullRowSelect = true;
			this.lvHistory.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.lvHistory.Location = new System.Drawing.Point(8, 12);
			this.lvHistory.MultiSelect = false;
			this.lvHistory.Name = "lvHistory";
			this.lvHistory.Size = new System.Drawing.Size(332, 164);
			this.lvHistory.TabIndex = 0;
			this.lvHistory.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "HCPCS Code";
			this.columnHeader1.Width = 120;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Activated";
			this.columnHeader2.Width = 100;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Inactivated";
			this.columnHeader3.Width = 100;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 184);
			this.grpImage.TabIndex = 3;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 8);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// DlgHcpcsHistory
			// 
			this.AcceptButton = this.btnOK;
			this.AccessibleDescription = "HICK PICKS History";
			this.AccessibleName = "HICK PICKS History";
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnOK;
			this.ClientSize = new System.Drawing.Size(412, 245);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpHistory);
			this.Controls.Add(this.btnOK);
			this.hlphelpChm.SetHelpKeyword(this, "Blood_Products.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(420, 272);
			this.Name = "DlgHcpcsHistory";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - HCPCS History";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpHistory, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.grpHistory.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Control Events

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.ResetLockTimer(this, System.EventArgs.Empty);
			this.Close();
		}

		#endregion

		#region Methods

		/// <summary>
		/// Fills the listview with the hcpcs history captured in the constructor
		/// </summary>
		private void PopulateHCPCSAssignments()
		{
			lvHistory.Items.Clear();
			
			//if there's nothing to show, display a nice user friendly message in the listview
			if (_dtHcpcsHistory.Rows.Count == 0)
			{
				ListViewItem lviHcpcs = new ListViewItem("No Hcpcs History on file");
				lvHistory.Items.Add(lviHcpcs);
			}
			else
			{
				//Loop through all the history which comes from the sproc already sorted in desc historical order
				foreach (System.Data.DataRow dr in _dtHcpcsHistory.Rows)
				{
					ListViewItem lviHcpcs = new ListViewItem(dr[HCPCS.HcpcsCode].ToString());

					try		//AssignedDate
					{
						DateTime assignedDate = System.Convert.ToDateTime(dr[HCPCS.AssignedDate]);
						lviHcpcs.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(assignedDate));
					}
					catch (System.FormatException)
					{
						lviHcpcs.SubItems.Add(dr[HCPCS.AssignedDate].ToString());
					}
					
					try		//UnAssignedDate
					{
						//The sproc spGetHcpsAssignmentHistory has to populate the null column with some valid
						//date format, otherwise it craps out for some reason now.  So this is a "fix"
						DateTime unassignedDate = System.Convert.ToDateTime(dr[HCPCS.UnAssignedDate]);
						if (unassignedDate.Year == 9999)		//DB DateTimeConversion turns NULL into 12/31/9999
						{
							lviHcpcs.SubItems.Add("");
						}
						else
						{
							lviHcpcs.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(unassignedDate));
						}
					}
					catch (System.FormatException)
					{
						lviHcpcs.SubItems.Add(dr[HCPCS.UnAssignedDate].ToString());
					}
					lviHcpcs.Tag = dr;
					lvHistory.Items.Add(lviHcpcs);
				}
			}
			
			controls.VbecsFunction.SetColumnWidths(this.lvHistory);
		}

		#endregion

	}
}

